/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.network;

import java.util.HashMap;
import java.util.Map;
import me.angel.challenges6t4.challenge.Challenge;
import me.angel.challenges6t4.challenge.ChallengeRegistry;
import me.angel.challenges6t4.challenge.ChallengeSettings;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class ChallengeNetworking {
    public static final class_2960 CHALLENGE_SYNC_ID = class_2960.method_60655((String)"challenges6t4", (String)"challenge_sync");
    public static final class_2960 CHALLENGE_UPDATE_ID = class_2960.method_60655((String)"challenges6t4", (String)"challenge_update");
    public static final class_2960 CHALLENGE_OPTIONS_UPDATE_ID = class_2960.method_60655((String)"challenges6t4", (String)"challenge_options_update");

    public static void registerNetworking() {
        PayloadTypeRegistry.playS2C().register(ChallengeSyncPayload.ID, ChallengeSyncPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ChallengeUpdatePayload.ID, ChallengeUpdatePayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ChallengeOptionsUpdatePayload.ID, ChallengeOptionsUpdatePayload.CODEC);
    }

    public static void sendToClient(class_3222 player) {
        HashMap<String, Boolean> challengeStates = new HashMap<String, Boolean>();
        HashMap<String, Map<String, Object>> challengeOptions = new HashMap<String, Map<String, Object>>();
        for (Challenge challenge : ChallengeRegistry.getAllChallenges()) {
            challengeStates.put(challenge.getId(), challenge.isEnabled());
            challengeOptions.put(challenge.getId(), ChallengeSettings.getChallengeOptions(challenge.getId()));
        }
        ServerPlayNetworking.send((class_3222)player, (class_8710)new ChallengeSyncPayload(challengeStates, challengeOptions));
    }

    public static void sendToAllClients(class_3222 fromPlayer) {
        if (fromPlayer != null && fromPlayer.method_5682() != null) {
            HashMap<String, Boolean> challengeStates = new HashMap<String, Boolean>();
            HashMap<String, Map<String, Object>> challengeOptions = new HashMap<String, Map<String, Object>>();
            for (Challenge challenge : ChallengeRegistry.getAllChallenges()) {
                challengeStates.put(challenge.getId(), challenge.isEnabled());
                challengeOptions.put(challenge.getId(), ChallengeSettings.getChallengeOptions(challenge.getId()));
            }
            ChallengeSyncPayload payload = new ChallengeSyncPayload(challengeStates, challengeOptions);
            for (class_3222 player : fromPlayer.method_5682().method_3760().method_14571()) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
            }
            System.out.println("Synced challenge states to " + fromPlayer.method_5682().method_3760().method_14571().size() + " clients");
        }
    }

    public record ChallengeSyncPayload(Map<String, Boolean> challengeStates, Map<String, Map<String, Object>> challengeOptions) implements class_8710
    {
        public static final class_8710.class_9154<ChallengeSyncPayload> ID = new class_8710.class_9154(CHALLENGE_SYNC_ID);
        public static final class_9139<class_9129, ChallengeSyncPayload> CODEC = new class_9139<class_9129, ChallengeSyncPayload>(){

            public ChallengeSyncPayload decode(class_9129 buf) {
                Map challengeStates = buf.method_34067(buffer -> buffer.method_19772(), buffer -> buffer.readBoolean());
                Map challengeOptions = buf.method_34067(buffer -> buffer.method_19772(), buffer -> buf.method_34067(innerBuffer -> innerBuffer.method_19772(), innerBuffer -> {
                    String valueType;
                    return switch (valueType = innerBuffer.method_19772()) {
                        case "boolean" -> innerBuffer.readBoolean();
                        case "int" -> innerBuffer.readInt();
                        case "float" -> Float.valueOf(innerBuffer.readFloat());
                        case "long" -> innerBuffer.readLong();
                        case "string" -> innerBuffer.method_19772();
                        default -> null;
                    };
                }));
                return new ChallengeSyncPayload(challengeStates, challengeOptions);
            }

            public void encode(class_9129 buf, ChallengeSyncPayload payload) {
                buf.method_34063(payload.challengeStates(), (buffer, key) -> buffer.method_10814(key), (buffer, value) -> buffer.method_52964(value.booleanValue()));
                buf.method_34063(payload.challengeOptions(), (buffer, key) -> buffer.method_10814(key), (buffer, value) -> buf.method_34063(value, (innerBuffer, optionKey) -> innerBuffer.method_10814(optionKey), (innerBuffer, optionValue) -> {
                    if (optionValue instanceof Boolean) {
                        innerBuffer.method_10814("boolean");
                        innerBuffer.method_52964(((Boolean)optionValue).booleanValue());
                    } else if (optionValue instanceof Integer) {
                        innerBuffer.method_10814("int");
                        innerBuffer.method_53002(((Integer)optionValue).intValue());
                    } else if (optionValue instanceof Float) {
                        innerBuffer.method_10814("float");
                        innerBuffer.method_52941(((Float)optionValue).floatValue());
                    } else if (optionValue instanceof Long) {
                        innerBuffer.method_10814("long");
                        innerBuffer.method_52974(((Long)optionValue).longValue());
                    } else if (optionValue instanceof String) {
                        innerBuffer.method_10814("string");
                        innerBuffer.method_10814((String)optionValue);
                    } else {
                        innerBuffer.method_10814("null");
                    }
                }));
            }
        };

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    public record ChallengeUpdatePayload(String challengeId, boolean enabled) implements class_8710
    {
        public static final class_8710.class_9154<ChallengeUpdatePayload> ID = new class_8710.class_9154(CHALLENGE_UPDATE_ID);
        public static final class_9139<class_9129, ChallengeUpdatePayload> CODEC = new class_9139<class_9129, ChallengeUpdatePayload>(){

            public ChallengeUpdatePayload decode(class_9129 buf) {
                String challengeId = buf.method_19772();
                boolean enabled = buf.readBoolean();
                return new ChallengeUpdatePayload(challengeId, enabled);
            }

            public void encode(class_9129 buf, ChallengeUpdatePayload payload) {
                buf.method_10814(payload.challengeId());
                buf.method_52964(payload.enabled());
            }
        };

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }

    public record ChallengeOptionsUpdatePayload(String challengeId, String optionKey, Object optionValue) implements class_8710
    {
        public static final class_8710.class_9154<ChallengeOptionsUpdatePayload> ID = new class_8710.class_9154(CHALLENGE_OPTIONS_UPDATE_ID);
        public static final class_9139<class_9129, ChallengeOptionsUpdatePayload> CODEC = new class_9139<class_9129, ChallengeOptionsUpdatePayload>(){

            public ChallengeOptionsUpdatePayload decode(class_9129 buf) {
                String valueType;
                String challengeId = buf.method_19772();
                String optionKey = buf.method_19772();
                return new ChallengeOptionsUpdatePayload(challengeId, optionKey, switch (valueType = buf.method_19772()) {
                    case "boolean" -> buf.readBoolean();
                    case "int" -> buf.readInt();
                    case "float" -> Float.valueOf(buf.readFloat());
                    case "long" -> buf.readLong();
                    case "string" -> buf.method_19772();
                    default -> null;
                });
            }

            public void encode(class_9129 buf, ChallengeOptionsUpdatePayload payload) {
                buf.method_10814(payload.challengeId());
                buf.method_10814(payload.optionKey());
                Object value = payload.optionValue();
                if (value instanceof Boolean) {
                    buf.method_10814("boolean");
                    buf.method_52964(((Boolean)value).booleanValue());
                } else if (value instanceof Integer) {
                    buf.method_10814("int");
                    buf.method_53002(((Integer)value).intValue());
                } else if (value instanceof Float) {
                    buf.method_10814("float");
                    buf.method_52941(((Float)value).floatValue());
                } else if (value instanceof Long) {
                    buf.method_10814("long");
                    buf.method_52974(((Long)value).longValue());
                } else if (value instanceof String) {
                    buf.method_10814("string");
                    buf.method_10814((String)value);
                } else {
                    buf.method_10814("null");
                }
            }
        };

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }
}

